import { TLINSTANCE_ID, pluckPreservingValues } from "@tldraw/tlschema";
import { WeakCache, filterEntries } from "@tldraw/utils";
import {
  createSessionStateSnapshotSignal,
  loadSessionStateSnapshotIntoStore
} from "./TLSessionStateSnapshot.mjs";
function loadSnapshot(store, _snapshot) {
  let snapshot = {};
  if ("store" in _snapshot) {
    const migrationResult = store.schema.migrateStoreSnapshot(_snapshot);
    if (migrationResult.type !== "success") {
      throw new Error("Failed to migrate store snapshot: " + migrationResult.reason);
    }
    snapshot.document = {
      schema: store.schema.serialize(),
      store: filterEntries(
        migrationResult.value,
        (_, { typeName }) => store.scopedTypes.document.has(typeName)
      )
    };
  } else {
    snapshot = _snapshot;
  }
  const preservingInstanceState = pluckPreservingValues(store.get(TLINSTANCE_ID));
  store.atomic(() => {
    if (snapshot.document) {
      store.loadStoreSnapshot(snapshot.document);
    }
    if (preservingInstanceState) {
      store.update(TLINSTANCE_ID, (r) => ({ ...r, ...preservingInstanceState }));
    }
    if (snapshot.session) {
      loadSessionStateSnapshotIntoStore(store, snapshot.session);
    }
  });
}
const sessionStateCache = new WeakCache();
function getSnapshot(store) {
  const sessionState$ = sessionStateCache.get(store, createSessionStateSnapshotSignal);
  const session = sessionState$.get();
  if (!session) {
    throw new Error("Session state is not ready yet");
  }
  return {
    document: store.getStoreSnapshot(),
    session
  };
}
export {
  getSnapshot,
  loadSnapshot
};
//# sourceMappingURL=TLEditorSnapshot.mjs.map
